/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.std;

import com.quantumdata.std.IQDConsole;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LogViewer
extends JDialog
implements ActionListener,
IQDConsole {
    private static final long serialVersionUID = 1L;
    private JTextArea m_text;
    private boolean m_hideOnClose = true;

    public LogViewer(String string) {
        super((Frame)null, string, false);
        this.createComponents(false);
    }

    public LogViewer(String string, boolean bl) {
        super((Frame)null, string, false);
        this.createComponents(bl);
    }

    private void createComponents(boolean bl) {
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(3, 3));
        Font font = new Font("Monospaced", 0, 10);
        this.m_text = new JTextArea(20, 50);
        this.m_text.setEditable(false);
        this.m_text.setFont(font);
        this.m_text.setTabSize(2);
        this.m_text.setBackground(new Color(96, 0, 0));
        this.m_text.setForeground(Color.WHITE);
        JScrollPane jScrollPane = new JScrollPane(this.m_text);
        container.add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel(new FlowLayout());
        JButton jButton = new JButton("Clear");
        jButton.setActionCommand("CLEAR");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        if (bl) {
            jButton = new JButton("Stop");
            jButton.setActionCommand("STOP");
            jButton.addActionListener(this);
            jPanel.add(jButton);
        }
        jButton = new JButton("Close");
        jButton.setActionCommand("CLOSE");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        container.add((Component)jPanel, "North");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void setHideOnClose(boolean bl) {
        this.m_hideOnClose = bl;
        if (bl) {
            this.setDefaultCloseOperation(1);
        } else {
            this.setDefaultCloseOperation(3);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("CLEAR")) {
            this.m_text.setText("");
        } else if (actionEvent.getActionCommand().equals("CLOSE")) {
            this.OnClose();
        } else if (actionEvent.getActionCommand().equals("STOP")) {
            this.OnStop();
        }
    }

    protected void OnStop() {
    }

    protected void OnClose() {
        if (this.m_hideOnClose) {
            this.setVisible(false);
        } else {
            System.exit(0);
        }
    }

    public void println(String string) {
        this.m_text.append(string + "\n");
        this.m_text.setCaretPosition(this.m_text.getText().length() - 1);
    }

    public void print(String string) {
        this.m_text.append(string);
        this.m_text.setCaretPosition(this.m_text.getText().length() - 1);
    }
}

